/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.bq;
import java.io.Serializable;

public class JA_DSAPublicKey
extends JSAFE_PublicKey
implements JSAFE_Key,
Cloneable,
Serializable {
    private int a;
    private int b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private byte[] f;

    public String getAlgorithm() {
        return "DSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"DSAPublicKey", "DSAPublicValue", "DSAPublicKeyBER", "DSAPublicKeyX957BER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.f == null) {
            return new String[0];
        }
        if (this.c == null || this.d == null || this.e == null) {
            String[] stringArray = new String[]{"DSAPublicValue", "DSAPublicKeyBER", "DSAPublicKeyX957BER"};
            return stringArray;
        }
        String[] stringArray = new String[]{"DSAPublicKey", "DSAPublicValue", "DSAPublicKeyBER", "DSAPublicKeyX957BER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        if (string.compareTo("DSAPublicKeyBER") == 0 || string.compareTo("DSAPublicKeyX957BER") == 0) {
            this.d();
            if (byArray == null || byArray.length != 1) {
                throw new JSAFE_UnimplementedException("Invalid BER DSA public key data.");
            }
            bq.a(this, byArray[0], 0);
            return;
        }
        if (string.compareTo("DSAPublicKey") == 0) {
            this.setKeyData(byArray);
            return;
        }
        if (string.compareTo("DSAPublicValue") == 0) {
            this.a(byArray);
            return;
        }
        this.d();
        throw new JSAFE_UnimplementedException("Unknown DSA key data format.");
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.d();
        this.e();
        if (byArray == null || byArray.length != 4) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key. Expects {prime, subPrime, base, privateValue}");
        }
        try {
            this.a(-1, byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, byArray[2], 0, byArray[2].length);
            this.a(byArray[3], 0, byArray[3].length);
        }
        catch (NullPointerException nullPointerException) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
    }

    private void a(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.d();
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
        if (byArray[0] == null) {
            throw new JSAFE_InvalidKeyException("Invalid input for DSA key.");
        }
        this.a(byArray[0], 0, byArray[0].length);
    }

    public void a(byte[] byArray, int n2) throws JSAFE_InvalidKeyException {
        this.d();
        bq.a(this, byArray, n2);
    }

    void a(int n2, byte[] byArray, int n3, int n4, byte[] byArray2, int n5, int n6, byte[] byArray3, int n7, int n8) throws JSAFE_InvalidKeyException {
        this.e();
        while (byArray[n3] == 0) {
            --n4;
            ++n3;
        }
        this.c = new byte[n4];
        System.arraycopy(byArray, n3, this.c, 0, n4);
        this.a = this.c.length * 8;
        int n9 = this.c[0] & 0xFF;
        int n10 = n9 & 0x80;
        while (n10 == 0) {
            --this.a;
            n10 = (n9 <<= 1) & 0x80;
        }
        if (n2 != -1 && this.a > n2) {
            throw new JSAFE_InvalidKeyException("DSA prime size mismatch.");
        }
        if (this.a < 512 || this.a > 4096) {
            throw new JSAFE_InvalidKeyException("Invalid DSA prime size.");
        }
        while (byArray2[n5] == 0) {
            --n6;
            ++n5;
        }
        this.d = new byte[n6];
        System.arraycopy(byArray2, n5, this.d, 0, n6);
        this.b = this.d.length * 8;
        n9 = this.d[0] & 0xFF;
        n10 = n9 & 0x80;
        while (n10 == 0) {
            --this.b;
            n10 = (n9 <<= 1) & 0x80;
        }
        if (this.b < 160 || this.b > 160) {
            throw new JSAFE_InvalidKeyException("Invalid DSA subprime size.");
        }
        while (byArray3[n7] == 0) {
            --n8;
            ++n7;
        }
        this.e = new byte[n8];
        System.arraycopy(byArray3, n7, this.e, 0, n8);
        if (this.e.length > this.c.length) {
            throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
        }
        if (this.e.length == this.c.length) {
            int n11;
            for (n11 = 0; n11 < this.e.length && (this.e[n11] & 0xFF) >= (this.c[n11] & 0xFF); ++n11) {
                if ((this.e[n11] & 0xFF) <= (this.c[n11] & 0xFF)) continue;
                throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
            }
            if (n11 >= this.e.length) {
                throw new JSAFE_InvalidKeyException("Invalid DSA base size.");
            }
        }
    }

    void a(byte[] byArray, int n2, int n3) throws JSAFE_InvalidKeyException {
        this.d();
        while (byArray[n2] == 0) {
            --n3;
            ++n2;
        }
        this.f = new byte[n3];
        System.arraycopy(byArray, n2, this.f, 0, n3);
        if (this.c == null || this.d == null || this.e == null) {
            return;
        }
        if (this.f.length > this.c.length) {
            throw new JSAFE_InvalidKeyException("DSA public value incompatible with previously stored parameters.");
        }
        if (this.f.length == this.c.length) {
            int n4;
            for (n4 = 0; n4 < this.f.length && (this.f[n4] & 0xFF) >= (this.c[n4] & 0xFF); ++n4) {
                if ((this.f[n4] & 0xFF) <= (this.c[n4] & 0xFF)) continue;
                throw new JSAFE_InvalidKeyException("DSA public value incompatible with previously stored parameters.");
            }
            if (n4 >= this.f.length) {
                throw new JSAFE_InvalidKeyException("DSA public value incompatible with previously stored parameters.");
            }
        }
    }

    public int getMaximumKeyLength() {
        return 4096;
    }

    public int getMinimumKeyLength() {
        return 512;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("DSAPublicKeyBER") == 0) {
            return this.a((String)null);
        }
        if (string.compareTo("DSAPublicKeyX957BER") == 0) {
            return this.a("DSAX957");
        }
        if (string.compareTo("DSAPublicValue") == 0) {
            return this.c();
        }
        if (string.compareTo("DSAPublicKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown DSA key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.c == null || this.d == null || this.e == null || this.f == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.c.length];
        System.arraycopy(this.c, 0, byArray, 0, this.c.length);
        byte[] byArray2 = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray2, 0, this.d.length);
        byte[] byArray3 = new byte[this.e.length];
        System.arraycopy(this.e, 0, byArray3, 0, this.e.length);
        byte[] byArray4 = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray4, 0, this.f.length);
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, byArray4};
        return byArrayArray;
    }

    private byte[][] c() {
        if (this.f == null) {
            return new byte[0][];
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    private byte[][] a(String string) {
        if (this.f == null) {
            return new byte[0][];
        }
        try {
            byte[] byArray = bq.a(string, this.c, this.d, this.e, this.f);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return new byte[0][];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_DSAPublicKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    public boolean dataEquals(Object object) {
        try {
            byte[][] byArray;
            JSAFE_PublicKey jSAFE_PublicKey = (JSAFE_PublicKey)object;
            if (this.f == null) {
                if (jSAFE_PublicKey.getAlgorithm().compareTo("DSA") != 0) {
                    return false;
                }
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!stringArray[i2].equals("DSAPublicKey")) continue;
                    return false;
                }
                return true;
            }
            if (this.c == null || this.d == null || this.e == null) {
                int n2;
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                for (n2 = 0; n2 < stringArray.length && stringArray[n2].compareTo("DSAPublicValue") == 0; ++n2) {
                }
                if (n2 != stringArray.length) {
                    return false;
                }
                byArray = jSAFE_PublicKey.getKeyData("DSAPublicValue");
            } else {
                byArray = jSAFE_PublicKey.getKeyData("DSAPublicKey");
            }
            int n3 = 0;
            if (byArray.length > 1) {
                if (!this.a(this.c, null, byArray[0], null)) {
                    return false;
                }
                if (!this.a(this.d, null, byArray[1], null)) {
                    return false;
                }
                if (!this.a(this.e, null, byArray[2], null)) {
                    return false;
                }
                n3 = 3;
            }
            if (!this.a(this.f, null, byArray[n3], null)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DSAPublicKey jA_DSAPublicKey = new JA_DSAPublicKey();
        this.a(jA_DSAPublicKey);
        return jA_DSAPublicKey;
    }

    protected void a(JA_DSAPublicKey jA_DSAPublicKey) throws CloneNotSupportedException {
        if (this.c != null) {
            jA_DSAPublicKey.c = (byte[])this.c.clone();
        }
        if (this.d != null) {
            jA_DSAPublicKey.d = (byte[])this.d.clone();
        }
        if (this.e != null) {
            jA_DSAPublicKey.e = (byte[])this.e.clone();
        }
        if (this.f != null) {
            jA_DSAPublicKey.f = (byte[])this.f.clone();
        }
        jA_DSAPublicKey.a = this.a;
        jA_DSAPublicKey.b = this.b;
        jA_DSAPublicKey.a((JSAFE_PublicKey)this);
    }

    private void d() {
        this.overwrite(this.f);
        this.f = null;
    }

    private void e() {
        this.overwrite(this.c);
        this.overwrite(this.e);
        this.overwrite(this.d);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = 0;
        this.a = 0;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.d();
        this.e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.clearSensitiveData();
        }
        finally {
            super.finalize();
        }
    }
}

