/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.xml.ParserHandler;
import com.rsa.certj.xml.XMLException;
import com.rsa.certj.xml.XPATHTransformer;
import com.rsa.certj.xml.dsig.Reference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPointerHandler {
    public static NodeList processXPointer(Node node, String string) throws XMLException {
        Element element = null;
        if (string == null) {
            throw new XMLException("XPointerHandler.processXPointer: xptr should not be null.");
        }
        if (node == null) {
            throw new XMLException("XPointerHandler.processXPointer: input node should not be null.");
        }
        int n2 = string.indexOf("(");
        int n3 = string.indexOf("(", n2 + 1);
        if (n3 == -1) {
            n3 = string.indexOf(")");
            if (n3 == -1) {
                throw new XMLException("Error in parsing XPointer: mismatched parenthesis");
            }
            if (string.substring(n2 + 1, n3).equals("/")) {
                return XPATHTransformer.toNodeset(node, null, true);
            }
            throw new XMLException("Error in parsing XPointer:Not supported xpointer function");
        }
        String string2 = string.substring(n2 + 1, n3);
        if (string2.equalsIgnoreCase("id")) {
            n2 = n3;
            if (!string.substring((n3 = string.indexOf(")", n2)) + 1).equals(")")) {
                throw new XMLException("Error in parsing XPointer:Valid id function format:id('IDName') or id(\"IDName\")");
            }
            String string3 = string.substring(n2 + 1, n3);
            if (string3.startsWith("'")) {
                string3 = string3.substring(1, string3.length() - 1);
            } else if (string3.startsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            ParserHandler.getStringValue(node, stringBuffer);
            element = Reference.resolveId(node, string3);
            if (element == null) {
                throw new XMLException("Error occured in processing XPointer:empty result");
            }
            return XPATHTransformer.toNodeset(element, null, true);
        }
        throw new XMLException("Error in parsing XPointer:Not supported xpointer function");
    }
}

