/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.C14NTransformer;
import com.rsa.certj.xml.XMLException;
import com.rsa.certj.xml.XPATHTransformer;
import com.rsa.certj.xml.dsig.EnvelopedTransformer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.NodeList;

public abstract class Transformer
implements Cloneable,
Serializable {
    public static final String[] BASE64_LIST;
    public static final String[] C14N_LIST;
    public static final String[] C14N_WITH_COMMENTS_LIST;
    public static final String[] XPATH_LIST;
    public static final String[] ENVELOPED_SIGNATURE_LIST;
    private static Transformer a;
    private static Transformer b;
    private static Transformer c;
    private static Transformer d;
    private static Hashtable e;

    public static Hashtable getAllTransformsInfo() {
        return e;
    }

    public abstract String getTransformAlgorithm();

    protected abstract void setTransformAlgorithm(String var1) throws XMLException;

    public static Transformer getInstance(String string) throws XMLException {
        if (string == null) {
            throw new XMLException("Input transform algorithm is null");
        }
        Enumeration enumeration = e.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            Transformer transformer = (Transformer)e.get(string);
            transformer.setTransformAlgorithm(string);
            try {
                return (Transformer)transformer.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new XMLException("Can't generate a Transformer on" + string);
            }
        }
        throw new XMLException("Not supported transform: " + string);
    }

    public abstract byte[] performTransformation(byte[] var1, int var2, int var3) throws XMLException;

    public abstract NodeList performTransformation(NodeList var1) throws XMLException;

    static {
        int n2;
        BASE64_LIST = new String[]{"http://www.w3.org/2000/09/xmldsig#base64", "http://www.w3.org/2000/07/xmldsig#base64"};
        C14N_LIST = new String[]{"http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/TR/2001/PR-xml-c14n-20010119", "http://www.w3.org/TR/2000/WD-xml-c14n-20001212", "http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "http://www.w3.org/TR/2000/WD-xml-c14n-20000907", "http://www.w3.org/TR/2000/WD-xml-c14n-20000710", "http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "http://www.w3.org/TR/2000/WD-xml-c14n-20000601"};
        C14N_WITH_COMMENTS_LIST = new String[]{"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "http://www.w3.org/TR/2001/PR-xml-c14n-20010119#WithComments", "http://www.w3.org/TR/2000/WD-xml-c14n-20001212#WithComments", "http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "http://www.w3.org/TR/2000/WD-xml-c14n-20000907#WithComments", "http://www.w3.org/TR/2000/WD-xml-c14n-20000710#WithComments", "http://www.w3.org/TR/2000/WD-xml-c14n-20000613#WithComments", "http://www.w3.org/TR/2000/WD-xml-c14n-20000601#WithComments"};
        XPATH_LIST = new String[]{"http://www.w3.org/TR/1999/REC-xpath-19991116"};
        ENVELOPED_SIGNATURE_LIST = new String[]{"http://www.w3.org/2000/09/xmldsig#enveloped-signature", "http://www.w3.org/2000/07/xmldsig#enveloped-signature"};
        a = new Base64Transformer();
        b = new C14NTransformer();
        c = new EnvelopedTransformer();
        d = new XPATHTransformer();
        e = new Hashtable();
        for (n2 = 0; n2 < BASE64_LIST.length; ++n2) {
            e.put(BASE64_LIST[n2], a);
        }
        for (n2 = 0; n2 < C14N_LIST.length; ++n2) {
            e.put(C14N_LIST[n2], b);
        }
        for (n2 = 0; n2 < C14N_WITH_COMMENTS_LIST.length; ++n2) {
            e.put(C14N_WITH_COMMENTS_LIST[n2], b);
        }
        for (n2 = 0; n2 < XPATH_LIST.length; ++n2) {
            e.put(XPATH_LIST[n2], d);
        }
        for (n2 = 0; n2 < ENVELOPED_SIGNATURE_LIST.length; ++n2) {
            e.put(ENVELOPED_SIGNATURE_LIST[n2], c);
        }
    }
}

