/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs12;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.FriendlyName;
import com.rsa.certj.cert.attributes.LocalKeyID;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs12.Cb;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JCMPInt;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;

public class PKCS12
implements Serializable {
    public static final int USE_MS_FORMAT = 1;
    public static final int USE_NS_FORMAT = 2;
    public static final String[] POSSIBLE_ENCRYPTION_ALGORITHMS = new String[]{"PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-1-3", "PBE/SHA1/RC4/PKCS12V1PBE-1-128", "PBE/SHA1/RC4/PKCS12V1PBE-1-40", "PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-1-2", "PBE/SHA1/RC2/CBC/PKCS12V1PBE-1-128", "PBE/SHA1/RC2/CBC/PKCS12V1PBE-1-40"};
    public static final String[] POSSIBLE_DIGEST_ALGORITHMS = new String[]{"SHA1"};
    public static final int DEFAULT_ITERATIONS = 1;
    public static final int[] POSSIBLE_OPTIONS = new int[]{1, 2};
    private static int a = 1024;
    private Cb b = null;
    private byte[] c;
    private CertJ d;

    protected PKCS12(CertJ certJ) {
        this.d = certJ;
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, InputStream inputStream, int n2) throws PKCS12Exception {
        this(certJ);
        this.a(databaseService, cArray, null, inputStream, n2);
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, char[] cArray2, InputStream inputStream, int n2) throws PKCS12Exception {
        this(certJ);
        this.a(databaseService, cArray, cArray2, inputStream, n2);
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, InputStream inputStream) throws PKCS12Exception {
        this(certJ, databaseService, cArray, inputStream, -1);
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, char[] cArray2, InputStream inputStream) throws PKCS12Exception {
        this(certJ, databaseService, cArray, cArray2, inputStream, -1);
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, String string) throws PKCS12Exception {
        this(certJ);
        if (string == null) {
            throw new PKCS12Exception("PKCS12.PKCS12: pkcs12File should not be null.");
        }
        this.a(databaseService, cArray, null, new File(string));
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, char[] cArray2, String string) throws PKCS12Exception {
        this(certJ);
        if (string == null) {
            throw new PKCS12Exception("PKCS12.PKCS12: pkcs12File should not be null.");
        }
        this.a(databaseService, cArray, cArray2, new File(string));
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, File file) throws PKCS12Exception {
        this(certJ);
        this.a(databaseService, cArray, null, file);
    }

    public PKCS12(CertJ certJ, DatabaseService databaseService, char[] cArray, char[] cArray2, File file) throws PKCS12Exception {
        this(certJ);
        this.a(databaseService, cArray, cArray2, file);
    }

    private void a(DatabaseService databaseService, char[] cArray, char[] cArray2, InputStream inputStream, int n2) throws PKCS12Exception {
        if (cArray == null) {
            throw new PKCS12Exception("PKCS12.importPKCS12: password should not be null.");
        }
        if (inputStream == null) {
            throw new PKCS12Exception("PKCS12.importPKCS12: inputStream should not be null.");
        }
        this.a(inputStream, n2);
        this.b = new Cb(this.d, databaseService, cArray, cArray2, this.c, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DatabaseService databaseService, char[] cArray, char[] cArray2, File file) throws PKCS12Exception {
        if (file == null) {
            throw new PKCS12Exception("PKCS12.import: pkcs12File should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.a(databaseService, cArray, cArray2, fileInputStream, (int)file.length());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PKCS12Exception("PKCS12.import: Could not find file " + file.toString() + "(" + fileNotFoundException.getMessage() + ")");
            }
            Object var8_6 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new PKCS12Exception("PKCS12.import: Could not close file " + file.toString() + "(" + iOException.getMessage() + ")");
            }
        }
        try {}
        catch (IOException iOException) {
            throw new PKCS12Exception("PKCS12.import: Could not close file " + file.toString() + "(" + iOException.getMessage() + ")");
        }
        fileInputStream.close();
    }

    private void a(InputStream inputStream, int n2) throws PKCS12Exception {
        try {
            if (n2 > 0) {
                this.c = new byte[n2];
                int n3 = inputStream.read(this.c);
                if (n2 != n3) {
                    throw new PKCS12Exception("PKCS12.readBER: Not enough bytes read. " + n2 + " bytes expected, " + n3 + " read.");
                }
            } else {
                int n4;
                int n5 = 0;
                byte[] byArray = new byte[]{};
                byte[] byArray2 = new byte[a];
                while ((n4 = inputStream.read(byArray2)) != -1) {
                    byte[] byArray3 = new byte[n5 + n4];
                    System.arraycopy(byArray, 0, byArray3, 0, n5);
                    System.arraycopy(byArray2, 0, byArray3, n5, n4);
                    n5 += n4;
                    byArray = byArray3;
                }
                this.c = byArray;
            }
        }
        catch (Exception exception) {
            throw new PKCS12Exception("PKCS12.readBER: error occurred while reading from stream " + inputStream.toString() + "(" + exception.getMessage() + ")");
        }
    }

    public PKCS12(CertJ certJ, Certificate[] certificateArray, CRL[] cRLArray, JSAFE_PrivateKey[] jSAFE_PrivateKeyArray, X501Attributes[] x501AttributesArray, X501Attributes[] x501AttributesArray2, X501Attributes[] x501AttributesArray3) throws InvalidParameterException {
        this(certJ, certificateArray, cRLArray, jSAFE_PrivateKeyArray, x501AttributesArray, x501AttributesArray2, x501AttributesArray3, null);
    }

    public PKCS12(CertJ certJ, Certificate[] certificateArray, CRL[] cRLArray, JSAFE_PrivateKey[] jSAFE_PrivateKeyArray, X501Attributes[] x501AttributesArray, X501Attributes[] x501AttributesArray2, X501Attributes[] x501AttributesArray3, String[] stringArray) throws InvalidParameterException {
        this(certJ);
        if (certificateArray == null && cRLArray == null && jSAFE_PrivateKeyArray == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: At least one of certs, crls and keys should not be null.");
        }
        if (jSAFE_PrivateKeyArray != null && certificateArray != null && (x501AttributesArray == null || x501AttributesArray3 == null)) {
            Certificate[] certificateArray2 = this.a(certificateArray, jSAFE_PrivateKeyArray);
            x501AttributesArray = x501AttributesArray == null ? new X501Attributes[certificateArray2.length] : PKCS12.a(certificateArray2, certificateArray, x501AttributesArray);
            if (x501AttributesArray3 == null) {
                x501AttributesArray3 = new X501Attributes[jSAFE_PrivateKeyArray.length];
            }
            this.a(certificateArray2, jSAFE_PrivateKeyArray, x501AttributesArray, x501AttributesArray3);
            this.b = new Cb(certificateArray2, cRLArray, jSAFE_PrivateKeyArray, x501AttributesArray, x501AttributesArray2, x501AttributesArray3, stringArray);
            return;
        }
        this.b = new Cb(certificateArray, cRLArray, jSAFE_PrivateKeyArray, x501AttributesArray, x501AttributesArray2, x501AttributesArray3, stringArray);
    }

    private static X501Attributes[] a(Certificate[] certificateArray, Certificate[] certificateArray2, X501Attributes[] x501AttributesArray) {
        int n2 = x501AttributesArray.length;
        X501Attributes[] x501AttributesArray2 = new X501Attributes[n2];
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (certificateArray[i2].hashCode() != certificateArray2[i3].hashCode()) continue;
                x501AttributesArray2[i2] = x501AttributesArray[i3];
                continue block0;
            }
        }
        return x501AttributesArray2;
    }

    private Certificate[] a(Certificate[] certificateArray, JSAFE_PrivateKey[] jSAFE_PrivateKeyArray) throws InvalidParameterException {
        int n2;
        int n3;
        String string = null;
        byte[][] byArray = null;
        byte[][] byArray2 = null;
        Certificate[] certificateArray2 = new Certificate[certificateArray.length];
        Vector<Certificate> vector = new Vector<Certificate>();
        JSAFE_PublicKey jSAFE_PublicKey = null;
        JCMPInt jCMPInt = new JCMPInt();
        JCMPInt jCMPInt2 = new JCMPInt();
        JCMPInt jCMPInt3 = new JCMPInt();
        JCMPInt jCMPInt4 = new JCMPInt();
        JCMPInt jCMPInt5 = new JCMPInt();
        int n4 = 0;
        for (n4 = 0; n4 < certificateArray.length; ++n4) {
            vector.addElement(certificateArray[n4]);
        }
        try {
            for (n4 = 0; n4 < jSAFE_PrivateKeyArray.length; ++n4) {
                string = jSAFE_PrivateKeyArray[n4].getAlgorithm();
                n3 = vector.size();
                if (string.equals("RSA")) {
                    byArray = jSAFE_PrivateKeyArray[n4].getKeyData("RSAPrivateKeyCRT");
                    for (n2 = 0; n2 < n3; ++n2) {
                        jSAFE_PublicKey = ((Certificate)vector.elementAt(n2)).getSubjectPublicKey("Java");
                        if (!jSAFE_PublicKey.getAlgorithm().equals("RSA")) continue;
                        byArray2 = jSAFE_PublicKey.getKeyData("RSAPublicKey");
                        if (byArray == null || byArray2 == null) {
                            throw new InvalidParameterException("Invalid RSA key.");
                        }
                        if (!CertJUtils.byteArraysEqual(byArray2[0], byArray[0]) || !CertJUtils.byteArraysEqual(byArray2[1], byArray[1])) continue;
                        certificateArray2[n4] = (Certificate)vector.elementAt(n2);
                        vector.removeElementAt(n2);
                        break;
                    }
                    if (n2 != n3) continue;
                    throw new InvalidParameterException("No corresponding cert found.");
                }
                if (!string.equals("DSA")) continue;
                byArray = jSAFE_PrivateKeyArray[n4].getKeyData("DSAPrivateKey");
                if (byArray == null || byArray[0] == null || byArray[2] == null || byArray[3] == null) {
                    throw new InvalidParameterException("Invalid DSA private key.");
                }
                jCMPInt.setValue(byArray[0], 0, byArray[0].length);
                jCMPInt2.setValue(byArray[2], 0, byArray[2].length);
                jCMPInt3.setValue(byArray[3], 0, byArray[3].length);
                jCMPInt2.modExp(jCMPInt3, jCMPInt, jCMPInt4);
                for (n2 = 0; n2 < n3; ++n2) {
                    jSAFE_PublicKey = ((Certificate)vector.elementAt(n2)).getSubjectPublicKey("Java");
                    if (!jSAFE_PublicKey.getAlgorithm().equals("DSA")) continue;
                    byArray2 = jSAFE_PublicKey.getKeyData("DSAPublicKey");
                    if (byArray2 == null || byArray2[3] == null) {
                        throw new InvalidParameterException("Invalid DSA public key.");
                    }
                    jCMPInt5.setValue(byArray2[3], 0, byArray2[3].length);
                    if (jCMPInt5.compareTo(jCMPInt4) != 0) continue;
                    certificateArray2[n4] = (Certificate)vector.elementAt(n2);
                    vector.removeElementAt(n2);
                    break;
                }
                if (n2 != n3) continue;
                throw new InvalidParameterException("No corresponding cert found.");
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new InvalidParameterException("Invalid key." + jSAFE_Exception.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new InvalidParameterException("Invalid certificate." + certificateException.getMessage());
        }
        n3 = vector.size();
        n2 = n4;
        for (int i2 = 0; i2 < n3; ++i2) {
            certificateArray2[n2] = (Certificate)vector.elementAt(i2);
            ++n2;
        }
        return certificateArray2;
    }

    public PKCS12(CertJ certJ, X500Name x500Name, CertPathCtx certPathCtx) throws InvalidParameterException, PKCS12Exception {
        this(certJ, x500Name, certPathCtx, null);
    }

    public PKCS12(CertJ certJ, X500Name x500Name, CertPathCtx certPathCtx, String string) throws InvalidParameterException, PKCS12Exception {
        this(certJ);
        int n2;
        Cloneable cloneable;
        if (certJ == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: certJ should not be null.");
        }
        if (x500Name == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: subjectName should not be null.");
        }
        if (certPathCtx == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: pathCtx should not be null.");
        }
        DatabaseService databaseService = certPathCtx.getDatabase();
        Vector vector = new Vector();
        int n3 = 0;
        try {
            n3 = databaseService.selectCertificateBySubject(x500Name, vector);
        }
        catch (Exception exception) {
            throw new PKCS12Exception("PKCS12.PKCS12: Finding certificates for the subjectName faild (" + exception.getMessage() + ").");
        }
        if (n3 == 0) {
            throw new PKCS12Exception("PKCS12.PKCS12: No certificate found for the subjectName(" + x500Name.toString() + ").");
        }
        Vector vector2 = new Vector();
        Vector<Cloneable> vector3 = new Vector<Cloneable>();
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                cloneable = databaseService.selectPrivateKeyByCertificate((Certificate)vector.elementAt(i2));
                if (cloneable == null) continue;
                vector3.addElement(cloneable);
                vector2.addElement(vector.elementAt(i2));
                continue;
            }
            catch (Exception exception) {
                throw new PKCS12Exception("PKCS12.PKCS12: Retrieving private key certificate failed(" + exception.getMessage() + ").");
            }
        }
        Vector vector4 = new Vector();
        cloneable = new Vector();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                certJ.buildCertPath(certPathCtx, vector2.elementAt(n2), vector2, (Vector)cloneable, vector4, null);
                continue;
            }
            catch (Exception exception) {
                throw new PKCS12Exception("PKCS12.PKCS12: Building certification path failed(" + exception.getMessage() + ").");
            }
        }
        for (n2 = 0; n2 < vector4.size(); ++n2) {
            vector2.addElement(vector4.elementAt(n2));
        }
        n3 = vector2.size();
        X501Attributes[] x501AttributesArray = new X501Attributes[n3];
        Certificate[] certificateArray = new Certificate[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            certificateArray[i3] = (Certificate)vector2.elementAt(i3);
        }
        n3 = ((Vector)cloneable).size();
        CRL[] cRLArray = null;
        if (n3 != 0) {
            cRLArray = new CRL[n3];
            for (int i4 = 0; i4 < n3; ++i4) {
                cRLArray[i4] = (CRL)((Vector)cloneable).elementAt(i4);
            }
        }
        n3 = vector3.size();
        X501Attributes[] x501AttributesArray2 = new X501Attributes[n3];
        JSAFE_PrivateKey[] jSAFE_PrivateKeyArray = new JSAFE_PrivateKey[n3];
        String[] stringArray = new String[n3];
        for (int i5 = 0; i5 < n3; ++i5) {
            jSAFE_PrivateKeyArray[i5] = (JSAFE_PrivateKey)vector3.elementAt(i5);
            stringArray[i5] = string;
        }
        this.a(certificateArray, jSAFE_PrivateKeyArray, x501AttributesArray, x501AttributesArray2);
        this.b = new Cb(certificateArray, cRLArray, jSAFE_PrivateKeyArray, x501AttributesArray, null, x501AttributesArray2, stringArray);
    }

    public PKCS12(CertJ certJ, Certificate certificate, CertPathCtx certPathCtx) throws InvalidParameterException, PKCS12Exception {
        this(certJ, certificate, certPathCtx, null);
    }

    public PKCS12(CertJ certJ, Certificate certificate, CertPathCtx certPathCtx, String string) throws InvalidParameterException, PKCS12Exception {
        this(certJ);
        int n2;
        if (certJ == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: cert should not be null.");
        }
        if (certificate == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: certJ should not be null.");
        }
        if (certPathCtx == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: pathCtx should not be null.");
        }
        DatabaseService databaseService = certPathCtx.getDatabase();
        Vector<Certificate> vector = new Vector<Certificate>();
        vector.addElement(certificate);
        Vector vector2 = new Vector();
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        try {
            jSAFE_PrivateKey = databaseService.selectPrivateKeyByCertificate(certificate);
        }
        catch (CertJException certJException) {
            throw new PKCS12Exception("PKCS12.PKCS12: Finding private key for given certificate failed(" + certJException.getMessage() + ").");
        }
        if (jSAFE_PrivateKey == null) {
            throw new PKCS12Exception("PKCS12.PKCS12: Matching private key not found.");
        }
        Vector vector3 = new Vector();
        try {
            certJ.buildCertPath(certPathCtx, certificate, vector, vector2, vector3, null);
        }
        catch (CertJException certJException) {
            throw new PKCS12Exception("PKCS12.PKCS12: Building certification path failed(" + certJException.getMessage() + ").");
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            vector.addElement((Certificate)vector3.elementAt(n2));
        }
        n2 = vector.size();
        X501Attributes[] x501AttributesArray = new X501Attributes[n2];
        Certificate[] certificateArray = new Certificate[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            certificateArray[i2] = (Certificate)vector.elementAt(i2);
        }
        n2 = vector2.size();
        CRL[] cRLArray = null;
        if (n2 != 0) {
            cRLArray = new CRL[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                cRLArray[i3] = (CRL)vector2.elementAt(i3);
            }
        }
        X501Attributes[] x501AttributesArray2 = new X501Attributes[1];
        JSAFE_PrivateKey[] jSAFE_PrivateKeyArray = new JSAFE_PrivateKey[]{jSAFE_PrivateKey};
        String[] stringArray = new String[]{string};
        this.a(certificateArray, jSAFE_PrivateKeyArray, x501AttributesArray, x501AttributesArray2);
        this.b = new Cb(certificateArray, cRLArray, jSAFE_PrivateKeyArray, x501AttributesArray, null, x501AttributesArray2, stringArray);
    }

    public void export(String string, char[] cArray, String string2, String string3, int n2, int n3) throws InvalidParameterException, PKCS12Exception {
        if (string == null) {
            throw new InvalidParameterException("PKCS12.export: filename should not be null.");
        }
        this.export(new File(string), cArray, string2, string3, n2, n3);
    }

    public void export(File file, char[] cArray, String string, String string2, int n2, int n3) throws InvalidParameterException, PKCS12Exception {
        FileOutputStream fileOutputStream;
        if (file == null) {
            throw new InvalidParameterException("PKCS12.export: file should not be null.");
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new PKCS12Exception("PKCS12.export: Creation of stream failed(" + iOException.getMessage() + ").");
        }
        this.export(fileOutputStream, cArray, string, string2, n2, n3);
    }

    public void export(String string, char[] cArray, char[] cArray2, String string2, String string3, int n2, int n3) throws InvalidParameterException, PKCS12Exception {
        if (string == null) {
            throw new InvalidParameterException("PKCS12.export: filename should not be null.");
        }
        this.export(new File(string), cArray, cArray2, string2, string3, n2, n3);
    }

    public void export(File file, char[] cArray, char[] cArray2, String string, String string2, int n2, int n3) throws InvalidParameterException, PKCS12Exception {
        FileOutputStream fileOutputStream;
        if (file == null) {
            throw new InvalidParameterException("PKCS12.export: file should not be null.");
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new PKCS12Exception("PKCS12.export: Creation of stream failed(" + iOException.getMessage() + ").");
        }
        this.export(fileOutputStream, cArray, cArray2, string, string2, n2, n3);
    }

    public void export(OutputStream outputStream, char[] cArray, String string, String string2, int n2, int n3) throws InvalidParameterException, PKCS12Exception {
        this.export(outputStream, cArray, null, string, string2, n2, n3);
    }

    public void export(OutputStream outputStream, char[] cArray, char[] cArray2, String string, String string2, int n2, int n3) throws InvalidParameterException, PKCS12Exception {
        if (outputStream == null) {
            throw new InvalidParameterException("PKCS12.export: stream should not be null.");
        }
        if (this.d == null) {
            throw new PKCS12Exception("PKCS12.export: Object not initialized with certJ.");
        }
        if (this.b == null) {
            throw new PKCS12Exception("PKCS12.export: Object not initialized with pfx.");
        }
        if (cArray == null) {
            throw new InvalidParameterException("PKCS12.export: password can not be null.");
        }
        if (string == null) {
            string = POSSIBLE_ENCRYPTION_ALGORITHMS[0];
        }
        if (string2 == null) {
            string2 = POSSIBLE_DIGEST_ALGORITHMS[0];
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = POSSIBLE_OPTIONS[0];
        } else if (!this.b(n3)) {
            throw new InvalidParameterException("PKCS12.export: option is invalid.");
        }
        this.c = this.b.a(this.d, cArray, cArray2, string, string2, n2, n3);
        try {
            outputStream.write(this.c);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new PKCS12Exception("PKCS12.export: Writing to stream failed(" + iOException.getMessage() + ").");
        }
    }

    private byte[] a(File file) throws PKCS12Exception {
        try {
            int n2 = (int)file.length();
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[n2];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            throw new PKCS12Exception("Could not open file " + file);
        }
    }

    public Certificate[] getCertificates() {
        if (this.b == null || this.b.b() == null) {
            return null;
        }
        Vector vector = this.b.b().a();
        Certificate[] certificateArray = new Certificate[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            certificateArray[i2] = (Certificate)vector.elementAt(i2);
        }
        return certificateArray;
    }

    public CRL[] getCrls() {
        if (this.b == null || this.b.b() == null) {
            return null;
        }
        Vector vector = this.b.b().b();
        CRL[] cRLArray = new CRL[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            cRLArray[i2] = (CRL)vector.elementAt(i2);
        }
        return cRLArray;
    }

    public JSAFE_PrivateKey[] getKeys() {
        if (this.b == null || this.b.b() == null) {
            return null;
        }
        Vector vector = this.b.b().c();
        JSAFE_PrivateKey[] jSAFE_PrivateKeyArray = new JSAFE_PrivateKey[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            jSAFE_PrivateKeyArray[i2] = (JSAFE_PrivateKey)vector.elementAt(i2);
        }
        return jSAFE_PrivateKeyArray;
    }

    public X501Attributes[] getKeysAttributes() {
        if (this.b == null || this.b.b() == null) {
            return null;
        }
        Vector vector = this.b.b().e();
        X501Attributes[] x501AttributesArray = new X501Attributes[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            x501AttributesArray[i2] = (X501Attributes)vector.elementAt(i2);
        }
        return x501AttributesArray;
    }

    public X501Attributes[] getCertsAttributes() {
        if (this.b == null || this.b.b() == null) {
            return null;
        }
        Vector vector = this.b.b().d();
        X501Attributes[] x501AttributesArray = new X501Attributes[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            x501AttributesArray[i2] = (X501Attributes)vector.elementAt(i2);
        }
        return x501AttributesArray;
    }

    public X501Attributes[] getCRLsAttributes() {
        if (this.b == null || this.b.b() == null) {
            return null;
        }
        Vector vector = this.b.b().f();
        X501Attributes[] x501AttributesArray = new X501Attributes[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            x501AttributesArray[i2] = (X501Attributes)vector.elementAt(i2);
        }
        return x501AttributesArray;
    }

    private void a(Certificate[] certificateArray, JSAFE_PrivateKey[] jSAFE_PrivateKeyArray, X501Attributes[] x501AttributesArray, X501Attributes[] x501AttributesArray2) {
        X501Attribute x501Attribute;
        Object object;
        int n2;
        for (n2 = 0; n2 < jSAFE_PrivateKeyArray.length; ++n2) {
            if (x501AttributesArray[n2] == null) {
                x501AttributesArray[n2] = new X501Attributes();
            }
            if (x501AttributesArray2[n2] == null) {
                x501AttributesArray2[n2] = new X501Attributes();
            }
            object = this.a(n2 + 1);
            x501Attribute = new LocalKeyID((byte[])object, 0, ((Object)object).length);
            FriendlyName friendlyName = new FriendlyName(((X509Certificate)certificateArray[n2]).getSubjectName().toString());
            if (x501AttributesArray[n2].getAttributeByType(3) == null) {
                x501AttributesArray[n2].addAttribute(friendlyName);
            }
            if (x501AttributesArray[n2].getAttributeByType(4) == null) {
                x501AttributesArray[n2].addAttribute(x501Attribute);
            }
            if (x501AttributesArray2[n2].getAttributeByType(3) == null) {
                x501AttributesArray2[n2].addAttribute(friendlyName);
            }
            if (x501AttributesArray2[n2].getAttributeByType(4) != null) continue;
            x501AttributesArray2[n2].addAttribute(x501Attribute);
        }
        for (n2 = jSAFE_PrivateKeyArray.length; n2 < certificateArray.length; ++n2) {
            object = new X501Attributes();
            x501Attribute = new FriendlyName(((X509Certificate)certificateArray[n2]).getSubjectName().toString());
            if (x501AttributesArray[n2] == null) {
                x501AttributesArray[n2] = new X501Attributes();
            }
            if (x501AttributesArray[n2].getAttributeByType(3) != null) continue;
            x501AttributesArray[n2].addAttribute(x501Attribute);
        }
    }

    private byte[] a(int n2) {
        return BigInteger.valueOf(n2).toByteArray();
    }

    private boolean b(int n2) {
        for (int i2 = 0; i2 < POSSIBLE_OPTIONS.length; ++i2) {
            if (n2 != POSSIBLE_OPTIONS[i2]) continue;
            return true;
        }
        return false;
    }
}

