/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class NameConstraints
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private GeneralSubtrees a;
    private static final int b = 0x810000;
    private GeneralSubtrees c;
    private static final int d = 0x810001;
    ASN1Template e;

    public NameConstraints() {
        this.extensionTypeFlag = 30;
        this.criticality = false;
        this.a = new GeneralSubtrees();
        this.c = new GeneralSubtrees();
        this.setStandardOID(30);
        this.extensionTypeString = "NameConstraints";
    }

    public NameConstraints(GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2, boolean bl2) {
        this.extensionTypeFlag = 30;
        this.criticality = bl2;
        if (generalSubtrees != null) {
            this.a = generalSubtrees;
        }
        if (generalSubtrees2 != null) {
            this.c = generalSubtrees2;
        }
        this.setStandardOID(30);
        this.extensionTypeString = "NameConstraints";
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(8466432);
        EncodedContainer encodedContainer2 = new EncodedContainer(8466433);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode Name Contraints extension.");
        }
        try {
            if (encodedContainer.dataPresent) {
                this.a = new GeneralSubtrees(encodedContainer.data, encodedContainer.dataOffset, 0x810000);
            }
            if (encodedContainer2.dataPresent) {
                this.c = new GeneralSubtrees(encodedContainer2.data, encodedContainer2.dataOffset, 0x810001);
            }
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode Name Constraints extension!!!.");
        }
    }

    public void setPermittedSubtrees(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees != null) {
            this.a = generalSubtrees;
        }
    }

    public void setExcludedSubtrees(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees != null) {
            this.c = generalSubtrees;
        }
    }

    public GeneralSubtrees getPermittedSubtrees() {
        return this.a;
    }

    public GeneralSubtrees getExcludedSubtrees() {
        return this.c;
    }

    public int derEncodeValueInit() {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = null;
        EncodedContainer encodedContainer2 = null;
        try {
            int n2;
            int n3;
            byte[] byArray;
            int n4;
            if (this.a != null) {
                n4 = this.a.getDERLen(0x810000);
                byArray = new byte[n4];
                n3 = 0;
                n2 = this.a.getDEREncoding(byArray, n3, 0x810000);
                encodedContainer = new EncodedContainer(8466432, true, 0, byArray, n3, n2);
            }
            if (this.c != null) {
                n4 = this.c.getDERLen(0x810001);
                byArray = new byte[n4];
                n3 = 0;
                n2 = this.c.getDEREncoding(byArray, n3, 0x810001);
                encodedContainer2 = new EncodedContainer(8466433, true, 0, byArray, n3, n2);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
        if (encodedContainer != null) {
            if (encodedContainer2 != null) {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, endContainer};
                this.e = new ASN1Template(aSN1ContainerArray);
            } else {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, endContainer};
                this.e = new ASN1Template(aSN1ContainerArray);
            }
        } else if (encodedContainer2 != null) {
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer2, endContainer};
            this.e = new ASN1Template(aSN1ContainerArray);
        } else {
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, endContainer};
            this.e = new ASN1Template(aSN1ContainerArray);
        }
        try {
            return this.e.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.e == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.e.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NameConstraints nameConstraints = new NameConstraints();
        if (this.a != null) {
            nameConstraints.a = (GeneralSubtrees)this.a.clone();
        }
        if (this.c != null) {
            nameConstraints.c = (GeneralSubtrees)this.c.clone();
        }
        if (this.e != null) {
            nameConstraints.derEncodeValueInit();
        }
        super.copyValues(nameConstraints);
        return nameConstraints;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.c = null;
        this.e = null;
    }
}

