/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class X509V3Extensions
implements Cloneable,
Serializable {
    protected Vector theExtensions;
    protected int special;
    private int a;
    public static final int X509_EXT_TYPE_CERT = 1;
    public static final int X509_EXT_TYPE_CRL = 2;
    public static final int X509_EXT_TYPE_CRL_ENTRY = 3;
    public static final int X509_EXT_TYPE_OCSP_SINGLE = 4;
    public static final int X509_EXT_TYPE_OCSP_REQUEST = 5;
    private int b = 1;
    private int c = 5;
    private ASN1Template d;

    public X509V3Extensions(int n2) throws CertificateException {
        if (n2 > this.c || n2 < this.b) {
            throw new CertificateException("Invalid extensions type.");
        }
        this.a = n2;
    }

    public X509V3Extensions(byte[] byArray, int n2, int n3, int n4) throws CertificateException {
        if (n4 > this.c || n4 < this.b) {
            throw new CertificateException("Invalid extensions type.");
        }
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a = n4;
        this.a(byArray, n2, n3);
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return n2 + ASN1Lengths.determineLength(byArray, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    private void a(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.reset();
        try {
            OfContainer ofContainer = new OfContainer(n3, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            if (n4 > 0) {
                this.theExtensions = new Vector();
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                X509V3Extension x509V3Extension = X509V3Extension.getInstance(aSN1Container.data, aSN1Container.dataOffset);
                switch (this.a) {
                    case 1: {
                        if (x509V3Extension instanceof CertExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 2: {
                        if (x509V3Extension instanceof CRLExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 3: {
                        if (x509V3Extension instanceof CRLEntryExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 4: {
                        if (x509V3Extension instanceof OCSPSingleExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                    case 5: {
                        if (x509V3Extension instanceof OCSPRequestExtension) break;
                        throw new CertificateException("Extension of the wrong type");
                    }
                }
                if (this.getExtensionByType(x509V3Extension.getExtensionType()) != null && x509V3Extension.getExtensionType() != -1) {
                    throw new CertificateException("Extension of " + x509V3Extension.getExtensionTypeString() + " type already exists.");
                }
                this.theExtensions.addElement(x509V3Extension);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not read the BER of the Extensions.");
        }
    }

    public int getDERLen(int n2) {
        return this.a(n2);
    }

    private int a(int n2) {
        this.special = n2;
        try {
            OfContainer ofContainer = new OfContainer(n2, true, 0, 12288, new EncodedContainer(12288));
            int n3 = 0;
            if (this.theExtensions != null) {
                n3 = this.theExtensions.size();
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                X509V3Extension x509V3Extension = (X509V3Extension)this.theExtensions.elementAt(i2);
                int n4 = x509V3Extension.getDERLen(0);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, n4);
                ofContainer.addContainer(encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.d = new ASN1Template(aSN1ContainerArray);
            return this.d.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            this.d = null;
            return 0;
        }
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return 0;
        }
        if ((this.d == null || n3 != this.special) && this.a(n3) == 0) {
            return 0;
        }
        int n4 = 0;
        try {
            n4 += this.d.derEncode(byArray, n2);
            this.d = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.d = null;
            return 0;
        }
        int n5 = 0;
        if (this.theExtensions != null) {
            n5 = this.theExtensions.size();
        }
        for (int i2 = 0; i2 < n5; ++i2) {
            X509V3Extension x509V3Extension = (X509V3Extension)this.theExtensions.elementAt(i2);
            n4 += x509V3Extension.getDEREncoding(byArray, n2 + n4, 0);
        }
        return n4;
    }

    public int addV3Extension(X509V3Extension x509V3Extension) throws CertificateException {
        if (x509V3Extension == null) {
            throw new CertificateException("Specified extension is null.");
        }
        this.reset();
        if (this.theExtensions == null) {
            this.theExtensions = new Vector();
        }
        switch (this.a) {
            case 1: {
                if (x509V3Extension instanceof CertExtension) break;
                throw new CertificateException("Extension of the wrong type");
            }
            case 2: {
                if (x509V3Extension instanceof CRLExtension) break;
                throw new CertificateException("Extension of the wrong type");
            }
            case 3: {
                if (x509V3Extension instanceof CRLEntryExtension) break;
                throw new CertificateException("Extension of the wrong type");
            }
        }
        if (this.getExtensionByType(x509V3Extension.getExtensionType()) != null && x509V3Extension.getExtensionType() != -1) {
            throw new CertificateException("Extension of " + x509V3Extension.getExtensionTypeString() + " type already exists.");
        }
        this.theExtensions.addElement(x509V3Extension);
        return this.theExtensions.indexOf(x509V3Extension);
    }

    public int getExtensionCount() {
        if (this.theExtensions != null) {
            return this.theExtensions.size();
        }
        return 0;
    }

    public int getExtensionsType() {
        return this.a;
    }

    public X509V3Extension getExtensionByIndex(int n2) throws CertificateException {
        if (this.theExtensions == null) {
            throw new CertificateException(" There is no extensions.");
        }
        if (n2 < this.getExtensionCount()) {
            return (X509V3Extension)this.theExtensions.elementAt(n2);
        }
        throw new CertificateException("Invalid index");
    }

    public X509V3Extension getExtensionByType(int n2) throws CertificateException {
        if (this.theExtensions == null) {
            throw new CertificateException("There is no extensions.");
        }
        int n3 = this.getExtensionCount();
        try {
            X509V3Extension x509V3Extension = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                x509V3Extension = this.getExtensionByIndex(i2);
                if (x509V3Extension.getExtensionType() != n2) continue;
                return (X509V3Extension)x509V3Extension.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Clone Exception");
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            X509V3Extensions x509V3Extensions = new X509V3Extensions(this.a);
            if (this.theExtensions != null) {
                x509V3Extensions.theExtensions = new Vector();
                int n2 = this.theExtensions.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    X509V3Extension x509V3Extension = (X509V3Extension)this.getExtensionByIndex(i2).clone();
                    x509V3Extensions.addV3Extension(x509V3Extension);
                }
            }
            if (this.d != null) {
                x509V3Extensions.getDERLen(this.special);
            }
            return x509V3Extensions;
        }
        catch (CertificateException certificateException) {
            throw new CloneNotSupportedException("Wrong Extensions type.");
        }
    }

    protected void reset() {
        this.d = null;
    }
}

