/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationDescriptorValidator
extends DefaultHandler {
    private static final String FILENAME_PATTERN = "[^\\*\"/:<>\\?\\\\|\\. ]|[^\\*\"/:<>\\?\\\\| ][^\\*\"/:<>\\?\\\\|]*[^\\*\"/:<>\\?\\\\|\\. ]";
    private static final String APP_ID_PATTERN = "[A-Za-z0-9\\-\\.]{1,212}";
    private static final String PUB_ID_PATTERN = "[A-Fa-f0-9]{40}\\.1";
    private static final String FOLDER_TYPE_PATTERN = "[^\\*\"/:<>\\?\\\\|\\. ]|[^\\*\"/:<>\\?\\\\| ][^\\*\":<>\\?\\\\|]*[^\\*\":<>\\?\\\\|\\./ ]";
    private static final String FILE_TYPE_NAME_PATTERN = "[A-Za-z][A-Za-z0-9\\.]{0,38}";
    private static final String EXTENSION_PATTERN = "[A-Za-z0-9]{1,38}";
    private static final String LANGUAGE_PATTERN = "[A-Za-z]{2,3}([\\-\\_][A-Za-z]{4})?([\\-\\_]([A-Za-z]{2}|[0-9]{3}))?";
    protected static final String SYSTEM_CHROME_NONE = "none";
    protected static final String SYSTEM_CHROME_STANDARD = "standard";
    private static final int CHUNK_HEADER_LENGTH = 8;
    private static final int IHDR_HEADER = 1229472850;
    private static final int IHDR_HEADER_SIZE = 13;
    private static final int CGBI_HEADER = 1130840649;
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR_WIDTH_FIELD_OFFSET = 0;
    private static final int IHDR_HEIGHT_FIELD_OFFSET = 4;
    private Listener _listener;
    private Locator _locator;
    private String _descriptorName;
    private boolean _hasRootElement = false;
    private boolean _inErrorState = false;
    private int _errorElementLevel;
    private ElementInfo _currentElementInfo;
    private StringBuffer _content = new StringBuffer();
    private String _rootContent;
    private Map<String, Dimension> _icons = new HashMap<String, Dimension>();

    private String getElementPath() {
        StringBuffer pathBuffer = new StringBuffer();
        ElementInfo elementInfo = this._currentElementInfo;
        while (elementInfo != null) {
            pathBuffer.insert(0, elementInfo.name);
            if ((elementInfo = elementInfo.parent) == null) continue;
            pathBuffer.insert(0, ".");
        }
        return pathBuffer.toString();
    }

    private static int bytesToInt(byte[] bytes, int offset) {
        int value = bytes[offset];
        value = (value << 8) + (bytes[offset + 1] & 0xFF);
        value = (value << 8) + (bytes[offset + 2] & 0xFF);
        value = (value << 8) + (bytes[offset + 3] & 0xFF);
        return value;
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (!this._inErrorState) {
            this._content.append(ch, start, length);
            String newContent = new String(ch, start, length).trim();
            if (newContent.length() != 0) {
                if (this._currentElementInfo.contentTypeMixed) {
                    Collection<ElementInfo> allowableElements = this._currentElementInfo.getChildren();
                    for (ElementInfo nodeInfo : allowableElements) {
                        if (nodeInfo.count <= 0) continue;
                        this.dispatchError(105, new String[]{this.getElementPath()});
                    }
                } else if (this._currentElementInfo.hasChildren()) {
                    this.dispatchError(105, new String[]{this.getElementPath()});
                }
            }
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        if (!this._hasRootElement) {
            this.dispatchError(104, new String[]{this.getRootElementInfo().name});
        }
        this.finalizeValidation();
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        --this._errorElementLevel;
        if (!this._inErrorState) {
            String elementPath = this.getElementPath();
            String elementValue = this._content.toString();
            if (!(this._currentElementInfo.hasChildren() && !this._currentElementInfo.contentTypeMixed || this.validateElement(elementPath, elementValue))) {
                this.dispatchError(105, new String[]{elementPath});
            }
            Collection<ElementInfo> allowableElements = this._currentElementInfo.getChildren();
            for (ElementInfo elementInfo : allowableElements) {
                if (elementInfo.count >= elementInfo.minOccurs) continue;
                this.dispatchError(104, new String[]{elementPath + "." + elementInfo.name});
            }
            this._content.setLength(0);
            this._currentElementInfo = this._currentElementInfo.parent;
        }
        if (this._inErrorState && this._errorElementLevel == 0) {
            this._inErrorState = false;
        }
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public final void setDescriptorName(String name) {
        this._descriptorName = name;
    }

    public final void setListener(Listener listener) {
        this._listener = listener;
    }

    public Set<String> getIcons() {
        return this._icons.keySet();
    }

    public boolean migrationGracePeriodInEffect() {
        return false;
    }

    public boolean usePackageSignatureForTimestamps() {
        return false;
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String elementPath = null;
        if (!this._inErrorState) {
            elementPath = this.getElementPath();
            if (this._currentElementInfo == null) {
                ElementInfo rootElementInfo = this.getRootElementInfo();
                if (!rootElementInfo.name.equals(localName)) {
                    this.dispatchError(103, new String[]{localName});
                    this._inErrorState = true;
                    this._errorElementLevel = 0;
                } else {
                    this._currentElementInfo = rootElementInfo;
                    this._hasRootElement = true;
                }
            } else {
                ElementInfo elementInfo;
                if (this._content.toString().trim().length() > 0) {
                    this.dispatchError(105, new String[]{elementPath});
                }
                if ((elementInfo = this._currentElementInfo.getChild(localName)) != null) {
                    ++elementInfo.count;
                    if (elementInfo.maxOccurs != -1 && elementInfo.count > elementInfo.maxOccurs) {
                        this.dispatchError(103, new String[]{elementPath + "." + localName});
                        this._inErrorState = true;
                        this._errorElementLevel = 0;
                    } else {
                        this._currentElementInfo = elementInfo;
                    }
                } else {
                    this.dispatchError(103, new String[]{elementPath + "." + localName});
                    this._inErrorState = true;
                    this._errorElementLevel = 0;
                }
            }
        }
        if (!this._inErrorState) {
            Collection<AttributeInfo> allowableAttributes = this._currentElementInfo.getAttributes();
            for (AttributeInfo nodeInfo : allowableAttributes) {
                nodeInfo.count = 0;
            }
            elementPath = this.getElementPath();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String attributeName = attributes.getQName(i2);
                String attributePath = elementPath + "@" + attributeName;
                AttributeInfo attributeInfo = this._currentElementInfo.getAttribute(attributeName);
                if (attributeInfo != null) {
                    ++attributeInfo.count;
                    if (this.validateAttribute(attributePath, attributes.getValue(i2))) continue;
                    this.dispatchError(105, new String[]{attributePath});
                    continue;
                }
                this.dispatchError(103, new String[]{attributePath});
            }
            for (AttributeInfo attributeInfo : allowableAttributes) {
                if (!attributeInfo.required || attributeInfo.count != 0) continue;
                this.dispatchError(104, new String[]{elementPath + "@" + attributeInfo.name});
            }
            Collection<ElementInfo> allowableElements = this._currentElementInfo.getChildren();
            for (ElementInfo nodeInfo : allowableElements) {
                nodeInfo.count = 0;
            }
            this._content.setLength(0);
        }
        ++this._errorElementLevel;
    }

    protected void dispatchError(int code, String[] identifiers) {
        this._listener.message(new Message(code, "ERROR", this._descriptorName, this._locator.getLineNumber(), this._locator.getColumnNumber(), identifiers));
    }

    protected URI validateUri(String uriString) {
        URI APP_RESOURCE_URI = URI.create("app:/");
        String uriValue = uriString.trim();
        URI uri = null;
        try {
            uri = APP_RESOURCE_URI.resolve(uriValue);
        }
        catch (IllegalArgumentException e2) {
            // empty catch block
        }
        if (uri == null || !uri.getScheme().equals(APP_RESOURCE_URI.getScheme())) {
            this.dispatchError(105, new String[]{this.getElementPath()});
        }
        return uri;
    }

    protected String validateRootContentURI(String rootContent) {
        URI uri = this.validateUri(rootContent);
        if (uri == null) {
            return null;
        }
        this._rootContent = uri.getPath().substring(1);
        return this._rootContent;
    }

    public void validateRootContentFile(Map<String, File> sources, boolean allowHTML) {
        if (!sources.containsKey(this._rootContent)) {
            this.dispatchError(302, new String[]{this._rootContent.trim()});
            return;
        }
        File file = sources.get(this._rootContent);
        try {
            this.validateRootContentFile(new FileInputStream(file), allowHTML);
        }
        catch (IOException ex) {
            this.dispatchError(300, new String[]{this._rootContent.trim()});
        }
    }

    public void validateRootContentFile(InputStream is, boolean allowHTML) {
        try {
            boolean isSWF;
            byte[] firstBytes = new byte[4];
            is.read(firstBytes);
            is.close();
            boolean bl2 = isSWF = (firstBytes[0] == 70 || firstBytes[0] == 67) && firstBytes[1] == 87 && firstBytes[2] == 83;
            if (isSWF) {
                byte version = firstBytes[3];
                if (version == 0) {
                    this.dispatchError(304, new String[0]);
                    return;
                }
                if (version > this.getMaximumSWFVersion()) {
                    this.dispatchError(305, new String[]{Integer.toString(version), this.getNamespace()});
                    return;
                }
            } else {
                boolean isPNG;
                if (!allowHTML) {
                    this.dispatchError(304, new String[0]);
                    return;
                }
                boolean isGIF = firstBytes[0] == 71 && firstBytes[1] == 73 && firstBytes[2] == 70;
                boolean isTIFFM = firstBytes[0] == 77 && firstBytes[1] == 77 && firstBytes[2] == 0 && firstBytes[3] == 42;
                boolean isTIFFI = firstBytes[0] == 73 && firstBytes[1] == 73 && firstBytes[2] == 42 && firstBytes[3] == 0;
                boolean isJPEG = firstBytes[0] == -1 && firstBytes[1] == -40;
                boolean bl3 = isPNG = firstBytes[0] == -119 && firstBytes[1] == 80 && firstBytes[2] == 78 && firstBytes[3] == 71;
                if (isGIF || isTIFFM || isTIFFI || isJPEG || isPNG) {
                    this.dispatchError(304, new String[0]);
                }
            }
        }
        catch (IOException ex) {
            this.dispatchError(300, new String[]{this._rootContent.trim()});
        }
    }

    protected String validateImageUri(String path, int width, int height) {
        URI uri = this.validateUri(path);
        if (uri == null) {
            return null;
        }
        String uriPath = uri.getPath().substring(1);
        if (this._icons.get(uriPath) != null && this._icons.get((Object)uriPath).width != width && this._icons.get((Object)uriPath).height != height) {
            this.dispatchError(201, new String[]{uriPath});
            return null;
        }
        this._icons.put(uriPath, new Dimension(width, height));
        return uriPath;
    }

    public void validateImageFiles(Map<String, File> sources, boolean allowCrushedPNG) {
        for (String path : this._icons.keySet()) {
            this.validateImageFile(sources, path, allowCrushedPNG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateImageFile(Map<String, File> sources, String iconPath, boolean allowCrushedPNG) {
        if (!sources.containsKey(iconPath)) {
            this.dispatchError(303, new String[]{iconPath.trim()});
            return;
        }
        File file = sources.get(iconPath);
        String uriValue = iconPath.trim();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.validateImage(fis, uriValue, allowCrushedPNG);
        }
        catch (Exception e2) {
            this.dispatchError(200, new String[]{uriValue});
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e3) {}
        }
    }

    public void validateImage(InputStream is, String name, boolean allowCrushedPNG) {
        block14: {
            if (!this._icons.containsKey(name)) {
                throw new IllegalStateException("Tried to validate an icon that's not in the descriptor");
            }
            int requiredWidth = this._icons.get((Object)name).width;
            int requiredHeight = this._icons.get((Object)name).height;
            try {
                byte[] preamble = new byte[PNG_SIGNATURE.length];
                if (is.read(preamble) != preamble.length) {
                    this.dispatchError(202, new String[]{name});
                    return;
                }
                for (int i2 = 0; i2 < PNG_SIGNATURE.length; ++i2) {
                    if (preamble[i2] == PNG_SIGNATURE[i2]) continue;
                    this.dispatchError(202, new String[]{name});
                    return;
                }
                byte[] firstHeaderBytes = new byte[8];
                if (is.read(firstHeaderBytes) != firstHeaderBytes.length) {
                    this.dispatchError(202, new String[]{name});
                    return;
                }
                int chunkSize = ApplicationDescriptorValidator.bytesToInt(firstHeaderBytes, 0);
                int header = ApplicationDescriptorValidator.bytesToInt(firstHeaderBytes, 4);
                if (header == 1130840649) {
                    if (!allowCrushedPNG) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    if (is.skip(chunkSize + 4) != (long)(chunkSize + 4)) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    byte[] secondHeaderBytes = new byte[8];
                    if (is.read(secondHeaderBytes) != secondHeaderBytes.length) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    chunkSize = ApplicationDescriptorValidator.bytesToInt(secondHeaderBytes, 0);
                    header = ApplicationDescriptorValidator.bytesToInt(secondHeaderBytes, 4);
                }
                if (header == 1229472850) {
                    if (chunkSize != 13) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    byte[] chunk = new byte[chunkSize];
                    if (is.read(chunk) != chunk.length) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    int pngWidth = ApplicationDescriptorValidator.bytesToInt(chunk, 0);
                    int pngHeight = ApplicationDescriptorValidator.bytesToInt(chunk, 4);
                    if (pngWidth != requiredWidth || pngHeight != requiredHeight) {
                        this.dispatchError(201, new String[]{name});
                        return;
                    }
                    break block14;
                }
                this.dispatchError(202, new String[]{name});
                return;
            }
            catch (Exception e2) {
                this.dispatchError(200, new String[]{name});
                return;
            }
        }
    }

    protected static boolean validateFilename(String name) {
        return name.matches(FILENAME_PATTERN);
    }

    protected static boolean validateAppId(String appId) {
        return appId.matches(APP_ID_PATTERN);
    }

    protected static boolean validatePublisherId(String pubId) {
        return pubId.matches(PUB_ID_PATTERN);
    }

    protected static boolean validateSystemChrome(String systemChrome) {
        return systemChrome.equals(SYSTEM_CHROME_NONE) || systemChrome.equals(SYSTEM_CHROME_STANDARD);
    }

    protected static boolean validateFolderType(String folderValue) {
        return folderValue.matches(FOLDER_TYPE_PATTERN);
    }

    protected static boolean validateFileTypeName(String fileTypeName) {
        return fileTypeName.matches(FILE_TYPE_NAME_PATTERN) && fileTypeName.charAt(fileTypeName.length() - 1) != '.' && fileTypeName.indexOf("..") == -1;
    }

    protected static boolean validateExtension(String extensionValue) {
        return extensionValue.matches(EXTENSION_PATTERN) && !extensionValue.equalsIgnoreCase("air");
    }

    protected static boolean validateEmptyContentType(String emptyContentValue) {
        return emptyContentValue.length() == 0;
    }

    protected static boolean validateBooleanType(String booleanValue) {
        return booleanValue.equals("true") || booleanValue.equals("false") || booleanValue.equals("1") || booleanValue.equals("0");
    }

    protected static boolean evaluateBooleanType(String booleanValue) {
        return booleanValue.equals("true") || booleanValue.equals("1");
    }

    protected static boolean validateUnsignedIntType(String unsignedIntValue) {
        long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
        long value = -1L;
        try {
            value = Long.parseLong(unsignedIntValue);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    protected static boolean validateUnsignedIntPairType(String inputString) {
        String[] list = inputString.split("\\s+");
        if (list.length == 2) {
            return ApplicationDescriptorValidator.validateUnsignedIntType(list[0]) && ApplicationDescriptorValidator.validateUnsignedIntType(list[1]);
        }
        return false;
    }

    protected static boolean validateSignedIntType(String unsignedIntValue) {
        long MAX_SIGNED_INT = Integer.MAX_VALUE;
        long MIN_SIGNED_INT = Integer.MIN_VALUE;
        long value = Long.MAX_VALUE;
        try {
            value = Long.parseLong(unsignedIntValue);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    protected boolean validatePListString(String s2) {
        boolean valid = true;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new InputSource(new StringReader(s2)));
            Node rootNode = document.getDocumentElement().getFirstChild();
            NodeList children = rootNode.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                String keyValue;
                Node child = children.item(i2);
                if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase("key") || !(keyValue = child.getTextContent()).equals("CFBundleVersion") && !keyValue.equals("CFBundleShortVersionString") && !keyValue.equals("CFBundleIdentifier") && !keyValue.equals("CFBundleInfoDictionaryVersion") && !keyValue.equals("CFBundleExecutable") && !keyValue.equals("CFBundleDisplayName") && !keyValue.equals("CFBundlePackageType") && !keyValue.equals("DTPlatformName") && !keyValue.equals("DTSDKName") && !keyValue.equals("MinimumOSVersion") && !keyValue.equals("NSMainNibFile") && !keyValue.equals("CFBundleResourceSpecification") && !keyValue.equals("UIStatusBarHidden") && !keyValue.equals("CTAutoOrients") && !keyValue.equals("CTInitialWindowVisible") && !keyValue.equals("CTInitialWindowTitle") && !keyValue.equals("CFBundleSupportedPlatforms")) continue;
                valid = false;
                break;
            }
            if (valid) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource schemaFile = new StreamSource(this.getClass().getResourceAsStream("PropertyList-1.0.xsd"));
                Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(document));
            }
        }
        catch (Exception e2) {
            valid = false;
        }
        return valid;
    }

    protected static boolean validateLanguageType(String langTypeValue) {
        return langTypeValue.matches(LANGUAGE_PATTERN);
    }

    protected abstract ElementInfo getRootElementInfo();

    protected abstract boolean validateAttribute(String var1, String var2) throws SAXException;

    protected abstract boolean validateElement(String var1, String var2) throws SAXException;

    protected abstract void finalizeValidation() throws SAXException;

    protected abstract int getMaximumSWFVersion();

    protected abstract String getNamespace();

    static final class AttributeInfo
    extends NodeInfo {
        public boolean required;

        public AttributeInfo(String name, boolean required) {
            super(name);
            this.required = required;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ElementInfo
    extends NodeInfo {
        public int minOccurs;
        public int maxOccurs;
        public boolean contentTypeMixed = false;
        private ElementInfo parent;
        private Map<String, ElementInfo> children = new HashMap<String, ElementInfo>();
        private Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();

        public ElementInfo(String name, int minOccurs, int maxOccurs) {
            super(name);
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }

        public void addAttribute(AttributeInfo attributeInfo) {
            this.attributes.put(attributeInfo.name, attributeInfo);
        }

        public void addChild(ElementInfo elementInfo) {
            elementInfo.parent = this;
            this.children.put(elementInfo.name, elementInfo);
        }

        public AttributeInfo getAttribute(String name) {
            return this.attributes.get(name);
        }

        public Collection<AttributeInfo> getAttributes() {
            return Collections.unmodifiableCollection(this.attributes.values());
        }

        public ElementInfo getChild(String name) {
            return this.children.get(name);
        }

        public Collection<ElementInfo> getChildren() {
            return Collections.unmodifiableCollection(this.children.values());
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }

    static abstract class NodeInfo {
        public String name;
        public int count;

        protected NodeInfo(String name) {
            this.name = name;
        }

        public boolean equal(Object object) {
            if (!(object instanceof NodeInfo)) {
                return false;
            }
            return ((NodeInfo)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

