/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTEntrypoint;
import com.adobe.air.ipa.IPAPackager;
import com.adobe.argv.UsageError;
import com.adobe.ucf.Packager;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.IOException;

public class PFI
extends ADTEntrypoint {
    private static final String EXT_IPA = "ipa";
    private static final String ARG_OPTIMIZE = "-Xo";
    private static final String ARG_COMPRESSSWF = "-XcompressSWF";
    private static final String ARG_VERBOSE = "-Xverbose";
    private static final String ARG_DEBUGGER = "-Xdebugger";
    private static final String ARG_PROVISIONING_PROFILE = "-provisioning-profile";

    public static void main(String[] args) {
        PFI pfi = new PFI();
        int result = pfi.run(args);
        System.exit(result);
    }

    public String getExecutableName() {
        return "pfi";
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  pfi -help");
        System.err.println("  pfi -package -target ( ipa-test | ipa-debug | ipa-app-store | ipa-ad-hoc ) -provisioning-profile <profile> SIGNING_OPTIONS <output-package> ( FILE_OPTIONS | <input-package> )");
        System.err.println("  pfi -version");
        System.err.println();
        System.err.println("SIGNING_OPTIONS: -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -alias <aliasName> )? ( -keypass <pass> )? ( -providerName <name> )?");
        System.err.println("FILE_OPTIONS:    <app-desc> <fileOrDir>* (( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ))*");
    }

    protected boolean parseUndocumentedParam() throws UsageError {
        if (this.args.peek(ARG_OPTIMIZE)) {
            this.args.accept(ARG_OPTIMIZE);
            String optimizeLevel = this.args.accept();
            int level = Integer.parseInt(optimizeLevel);
            if (level < 1 || level > 3) {
                throw new UsageError("Invalid value for -Xo. Valid value range: [1 - 3]");
            }
            this.getIPAPackager().setOptimizeLevel(optimizeLevel);
        } else if (this.args.peek(ARG_COMPRESSSWF)) {
            this.args.accept(ARG_COMPRESSSWF);
            this.getIPAPackager().setCompressSWF(true);
        } else if (this.args.peek(ARG_VERBOSE)) {
            this.args.accept(ARG_VERBOSE);
            this.getIPAPackager().setVerbose(true);
        } else if (this.args.peek(ARG_DEBUGGER)) {
            this.args.accept(ARG_DEBUGGER);
            this.getIPAPackager().setDebugger(true);
        } else {
            return false;
        }
        return true;
    }

    protected void parseAppSigningOptions() throws UsageError {
    }

    protected void parseTarget() throws UsageError {
        this.args.accept("-target");
        String targetValue = this.args.accept();
        if (!(targetValue.equals("ipa-test") || targetValue.equals("ipa-debug") || targetValue.equals("ipa-ad-hoc") || targetValue.equals("ipa-app-store"))) {
            throw new UsageError("unknown package target " + targetValue + "; should be ipa-test, ipa-debug, ipa-app-store or ipa-ad-hoc");
        }
        this.getIPAPackager().setPackageConfiguration(targetValue);
    }

    protected boolean cacheSigningOption(UCF.SigningOptions options) throws UsageError {
        if (this.args.peek("-tsa")) {
            throw new UsageError("-tsa option not supported");
        }
        return super.cacheSigningOption(options);
    }

    protected void parseNativeSigningOptions() throws UsageError {
        if (this.args.peek(ARG_PROVISIONING_PROFILE)) {
            this.args.accept(ARG_PROVISIONING_PROFILE);
            try {
                this.getIPAPackager().setMobileProvisioningProfile(new File(this.args.accept()).getCanonicalFile());
            }
            catch (IOException ie) {
                throw new UsageError("Error accessing mobile provisioning profile: " + ie.getMessage());
            }
        } else if (!this.signingOptionNext(this.args)) {
            throw new UsageError("expected signing options");
        }
        super.parseNativeSigningOptions();
    }

    protected String getExtension() {
        return EXT_IPA;
    }

    private IPAPackager getIPAPackager() {
        return (IPAPackager)this.getPackager();
    }

    protected Packager newPackager() {
        return new IPAPackager();
    }
}

