/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.ucf.ISigner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class MachoSigner
implements ISigner {
    private static final String SHA1_WITH_RSA = "SHA1withRSA";
    private static final String SHA1 = "SHA1";
    private static final int PAGE_SIZE = 4096;
    private static final String CHAIN_RESOURCE_PATH = "com/adobe/air/ipa/AppleChain.pem";
    private String applicationIdentifier = null;
    private String applicationIdentifierPrefix = null;
    private PrivateKey signingKey = null;
    private Certificate signingCert = null;
    private List<Certificate> signingChain = new ArrayList<Certificate>();
    private byte[] hashInfoPlist = null;
    private byte[] hashCodeResources = null;

    protected MachoSigner() {
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("usage: signipa <macho> <info> <resources>");
            System.err.println("\twhere these are the executable, Info.plist, and _CodeSignature/CodeResources as in an application");
            System.exit(2);
        }
        try {
            File macho = new File(args[0]);
            File info = new File(args[1]);
            File codeResources = new File(args[2]);
            MachoSigner moi = new MachoSigner();
            String appIdentifier = "com.adobe.airteam.HelloWorld";
            String appIdentifierPrefix = "4S8DP9N7J5";
            moi.setApplicationIdentifier(appIdentifier);
            moi.setApplicationIdentifierPrefix(appIdentifierPrefix);
            moi.setHashInfoPlist(MachoSigner.newDigestOfFile(info));
            moi.setHashCodeResources(MachoSigner.newDigestOfFile(codeResources));
            String pkcs12SigningCertificatePath = "/Users/cahaverl/temp/air/xcode/RoryLydon.p12";
            String pkcs12SigningCertificatePassword = "flash10";
            moi.loadSigningCert(pkcs12SigningCertificatePath, pkcs12SigningCertificatePassword);
            moi.loadCertificateChain();
            moi.sign(macho);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(3);
        }
        System.err.println("hello, world!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(File unsignedMacho) throws IOException, CertificateNotYetValidException, CertificateExpiredException, GeneralSecurityException {
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(unsignedMacho, "rw");
            this.sign(raFile);
        }
        finally {
            if (raFile != null) {
                raFile.close();
            }
            raFile = null;
        }
    }

    private void sign(RandomAccessFile macho) throws IOException, CertificateNotYetValidException, CertificateExpiredException, GeneralSecurityException {
        this.loadCertificateChain();
        if (this.applicationIdentifier == null) {
            throw new IllegalStateException("Missing application identifier");
        }
        if (this.applicationIdentifierPrefix == null) {
            throw new IllegalStateException("Missing application identifier prefix");
        }
        if (this.hashCodeResources == null) {
            throw new IllegalStateException("Missing hash for CodeResources");
        }
        if (this.hashInfoPlist == null) {
            throw new IllegalStateException("Missing hash for Info.plist");
        }
        if (this.signingCert == null) {
            throw new IllegalStateException("Missing signing certificate");
        }
        if (this.signingKey == null) {
            throw new IllegalStateException("Missing signing private key");
        }
        if (this.signingChain.size() == 0) {
            throw new IllegalStateException("Empty certificate chain");
        }
        if (!(this.signingCert instanceof X509Certificate)) {
            throw new CertificateException("Only X509Certificates are supported");
        }
        ((X509Certificate)this.signingCert).checkValidity(new Date());
        X500Principal issuerX500 = ((X509Certificate)this.signingCert).getIssuerX500Principal();
        boolean foundIssuer = false;
        for (Certificate maybeIssuer : this.signingChain) {
            X500Principal nameX500 = ((X509Certificate)maybeIssuer).getSubjectX500Principal();
            if (!issuerX500.equals(nameX500)) continue;
            foundIssuer = true;
            break;
        }
        if (!foundIssuer) {
            throw new CertificateException("The signing certficate is not from the expected issuer");
        }
        int MACH_MAGIC = -17958194;
        if (this.readIntLE(macho) != -17958194) {
            System.err.println("not a MachO binary");
            System.exit(3);
        }
        int oldEndOfLinkEditSegment = (int)macho.length();
        int startOfCodeSignature = (oldEndOfLinkEditSegment + 15) / 16 * 16;
        boolean isDistributionCert = new X500Name(((X509Certificate)this.signingCert).getSubjectX500Principal().getName()).getCommonName().startsWith("iPhone Distribution:");
        byte[] entitlementBlob = this.newEntitlementBlob(this.applicationIdentifierPrefix, this.applicationIdentifier, isDistributionCert);
        byte[] requirementsBlob = this.newRequirementsBlob();
        byte[] tempCodeDirectoryBlob = this.newCodeDirectoryBlob(macho, startOfCodeSignature, this.applicationIdentifier, entitlementBlob, requirementsBlob);
        byte[] tempCMSBlob = this.newCMSBlob(tempCodeDirectoryBlob);
        int signatureHeaderLength = 12;
        int slotIndexLength = 32;
        int codeDirectoryOffset = 44;
        int requirementsOffset = 44 + tempCodeDirectoryBlob.length;
        int entitlementsOffset = requirementsOffset + requirementsBlob.length;
        int cmsSignatureOffset = entitlementsOffset + entitlementBlob.length;
        int signatureLength = (cmsSignatureOffset + tempCMSBlob.length + 15) / 16 * 16;
        long OFFSET_TO_NCMDS_FIELD = 16L;
        macho.seek(16L);
        int numLoadCommands = this.readIntLE(macho);
        int MACH_HEADER_SIZE = 28;
        int linkEditSegmentCommandOffset = 0;
        boolean LC_SEGMENT = true;
        macho.seek(28L);
        for (int commandIdx = 0; commandIdx < numLoadCommands; ++commandIdx) {
            int currentOffset = (int)macho.getFilePointer();
            int commandType = this.readIntLE(macho);
            int commandSize = this.readIntLE(macho);
            if (commandType == 1) {
                byte[] LINKEDIT_SEGMENT_NAME = new byte[]{95, 95, 76, 73, 78, 75, 69, 68, 73, 84, 0, 0, 0, 0, 0, 0};
                byte[] segmentName = new byte[16];
                macho.read(segmentName);
                if (Arrays.equals(segmentName, LINKEDIT_SEGMENT_NAME)) {
                    linkEditSegmentCommandOffset = currentOffset;
                    break;
                }
            }
            macho.seek(currentOffset + commandSize);
        }
        if (linkEditSegmentCommandOffset == 0) {
            System.err.println("no __LINKEDIT command");
            System.exit(3);
        }
        int vmSizeOffset = linkEditSegmentCommandOffset + 12 + 16;
        int fileSizeOffset = linkEditSegmentCommandOffset + 20 + 16;
        macho.seek(fileSizeOffset);
        int oldLinkEditSegmentSize = this.readIntLE(macho);
        int newLinkEditSegmentSize = (oldLinkEditSegmentSize + 15) / 16 * 16 + signatureLength;
        int vmsize = (newLinkEditSegmentSize + 4096 - 1) / 4096 * 4096;
        macho.seek(fileSizeOffset);
        this.writeIntLE(macho, newLinkEditSegmentSize);
        macho.seek(vmSizeOffset);
        this.writeIntLE(macho, vmsize);
        macho.seek(16L);
        this.writeIntLE(macho, numLoadCommands + 1);
        long OFFSET_TO_SIZEOFCMDS = 20L;
        int CODESIGNATURE_COMMAND_SIZE = 16;
        macho.seek(20L);
        int originalLoadCommandSize = this.readIntLE(macho);
        macho.seek(20L);
        this.writeIntLE(macho, originalLoadCommandSize + 16);
        int MACHO_HEADER_SIZE = 28;
        long endOfExistingLoadCommands = 28 + originalLoadCommandSize;
        int CODESIGNATURE_COMMAND_MAGIC = 29;
        macho.seek(endOfExistingLoadCommands);
        this.writeIntLE(macho, 29);
        this.writeIntLE(macho, 16);
        this.writeIntLE(macho, startOfCodeSignature);
        this.writeIntLE(macho, signatureLength);
        macho.seek(oldEndOfLinkEditSegment);
        for (int i2 = oldEndOfLinkEditSegment; i2 < startOfCodeSignature; ++i2) {
            macho.write(0);
        }
        byte[] codeDirectoryBlob = this.newCodeDirectoryBlob(macho, startOfCodeSignature, this.applicationIdentifier, entitlementBlob, requirementsBlob);
        byte[] cmsBlob = this.newCMSBlob(codeDirectoryBlob);
        int SIGNATURE_MAGIC = -86111040;
        macho.seek(startOfCodeSignature);
        macho.writeInt(-86111040);
        macho.writeInt(signatureLength);
        int numberOfSignatureBlobs = 4;
        macho.writeInt(4);
        boolean SLOT_TYPE_CODE_DIRECTORY = false;
        int SLOT_TYPE_REQUIREMENTS = 2;
        int SLOT_TYPE_ENTITLEMENTS = 5;
        int SLOT_TYPE_SIGNATURE = 65536;
        macho.writeInt(0);
        macho.writeInt(44);
        macho.writeInt(2);
        macho.writeInt(requirementsOffset);
        macho.writeInt(5);
        macho.writeInt(entitlementsOffset);
        macho.writeInt(65536);
        macho.writeInt(cmsSignatureOffset);
        macho.write(codeDirectoryBlob);
        macho.write(requirementsBlob);
        macho.write(entitlementBlob);
        macho.write(cmsBlob);
        while (macho.getFilePointer() < (long)(startOfCodeSignature + signatureLength)) {
            macho.write(0);
        }
    }

    private byte[] newEntitlementBlob(String seedIdentifier, String appIdentifier, boolean isDistributionCert) throws UnsupportedEncodingException {
        StringBuilder entitlement = new StringBuilder();
        entitlement.append("\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n\t<key>application-identifier</key><string>");
        entitlement.append(seedIdentifier);
        entitlement.append(".");
        entitlement.append(appIdentifier);
        entitlement.append("</string>\n\t<key>get-task-allow</key><");
        entitlement.append(isDistributionCert ? "false" : "true");
        entitlement.append("/>\n</dict>\n</plist>");
        int MAGIC = -86085263;
        int size = 8 + entitlement.length();
        ByteBuffer result = ByteBuffer.allocate(size);
        result.putInt(-86085263);
        result.putInt(size);
        result.put(entitlement.toString().getBytes("UTF-8"));
        return result.array();
    }

    private byte[] newRequirementsBlob() {
        int MAGIC = -86111231;
        int SIZE = 12;
        boolean ZERO = false;
        ByteBuffer result = ByteBuffer.allocate(12);
        result.putInt(-86111231);
        result.putInt(12);
        result.putInt(0);
        return result.array();
    }

    private byte[] newCodeDirectoryBlob(RandomAccessFile macho, int endOfSignedImage, String appIdentifier, byte[] entitlementBlob, byte[] requirementsBlob) throws IOException, NoSuchAlgorithmException {
        int MAGIC = -86111230;
        int VERSION = 131073;
        boolean FLAGS = false;
        int NUM_SPECIAL_SLOTS = 5;
        int IDENT_OFFSET = 44;
        int SHA1_HASH_SIZE = 20;
        boolean SHA1_HASH_TYPE = true;
        int LOG_OF_PAGE_SIZE = 12;
        boolean UNUSED_ZERO = false;
        byte[] identifierUTF8 = appIdentifier.getBytes("UTF-8");
        int numCodeSlots = (endOfSignedImage + 4096 - 1) / 4096;
        int hashOffset = 44 + identifierUTF8.length + 1 + 100;
        int codeDirSize = 44 + identifierUTF8.length + 1 + (5 + numCodeSlots) * 20;
        ByteBuffer result = ByteBuffer.allocate(codeDirSize);
        result.putInt(-86111230);
        result.putInt(codeDirSize);
        result.putInt(131073);
        result.putInt(0);
        result.putInt(hashOffset);
        result.putInt(44);
        result.putInt(5);
        result.putInt(numCodeSlots);
        result.putInt(endOfSignedImage);
        result.put((byte)20);
        result.put((byte)1);
        result.put((byte)0);
        result.put((byte)12);
        result.putInt(0);
        result.put(appIdentifier.getBytes("UTF-8"));
        result.put((byte)0);
        MessageDigest sha1hasher = MessageDigest.getInstance("SHA-1");
        result.put(sha1hasher.digest(entitlementBlob));
        for (int i2 = 0; i2 < 20; ++i2) {
            result.put((byte)0);
        }
        result.put(this.hashCodeResources);
        result.put(sha1hasher.digest(requirementsBlob));
        result.put(this.hashInfoPlist);
        macho.seek(0L);
        byte[] buffer = new byte[4096];
        for (long bytesRemaining = (long)endOfSignedImage; bytesRemaining > 0L; bytesRemaining -= 4096L) {
            int bytesRead = macho.read(buffer, 0, (int)Math.min(4096L, bytesRemaining));
            sha1hasher.update(buffer, 0, bytesRead);
            result.put(sha1hasher.digest());
        }
        return result.array();
    }

    private byte[] newCMSBlob(byte[] codeDirectoryBlob) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream signatureStream = new ByteArrayOutputStream(4096);
        this.signToStream(signatureStream, codeDirectoryBlob);
        int MAGIC = -86111487;
        int size = 8 + signatureStream.size();
        ByteBuffer result = ByteBuffer.allocate(size);
        result.putInt(-86111487);
        result.putInt(size);
        result.put(signatureStream.toByteArray());
        byte[] rawResult = result.array();
        return rawResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signToStream(OutputStream signatureStream, byte[] bytesToSign) throws IOException, GeneralSecurityException {
        byte[] signatureBytes;
        PKCS9Attributes authenticatedPkcs9Attributes;
        block4: {
            MessageDigest digester = MessageDigest.getInstance(SHA1);
            digester.update(bytesToSign);
            byte[] digestBytes = digester.digest();
            Date signingDate = new Date();
            PKCS9Attribute[] pkcs9AttributeArray = new PKCS9Attribute[]{new PKCS9Attribute(PKCS9Attribute.CONTENT_TYPE_OID, ContentInfo.DATA_OID), new PKCS9Attribute(PKCS9Attribute.MESSAGE_DIGEST_OID, digestBytes), new PKCS9Attribute(PKCS9Attribute.SIGNING_TIME_OID, signingDate)};
            authenticatedPkcs9Attributes = new PKCS9Attributes(pkcs9AttributeArray);
            signatureBytes = null;
            try {
                Signature signature = Signature.getInstance(SHA1_WITH_RSA);
                signature.initSign(this.signingKey);
                signature.update(authenticatedPkcs9Attributes.getDerEncoding());
                signatureBytes = signature.sign();
            }
            catch (NoSuchAlgorithmException e2) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        PKCS9Attributes unauthenticatedPkcs9Attributes = null;
        X500Name signingCertificateName = new X500Name(((X509Certificate)this.signingCert).getIssuerX500Principal().getName());
        byte[] fixedAsn1 = this.asn1ConvertPrintableStringToUtf8(signingCertificateName.getEncoded());
        X500Name setStraightName = new X500Name(fixedAsn1);
        BigInteger signingCertificateSerial = ((X509Certificate)this.signingCert).getSerialNumber();
        SignerInfo signerInfo = new SignerInfo(setStraightName, signingCertificateSerial, new AlgorithmId(AlgorithmId.SHA_oid), authenticatedPkcs9Attributes, new AlgorithmId(AlgorithmId.RSAEncryption_oid), signatureBytes, unauthenticatedPkcs9Attributes);
        ContentInfo noContent = new ContentInfo(ContentInfo.DATA_OID, null);
        AlgorithmId[] algorithmIds = new AlgorithmId[]{AlgorithmId.get(SHA1)};
        SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
        PKCS7 pkcs7 = new PKCS7(algorithmIds, noContent, this.signingChain.toArray(new X509Certificate[0]), signerInfos);
        pkcs7.encodeSignedData(signatureStream);
    }

    private byte[] asn1ConvertPrintableStringToUtf8(byte[] asn1bytes) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(asn1bytes.length);
        block4: for (int i2 = 0; i2 < asn1bytes.length; i2 += length) {
            byte dataType = asn1bytes[i2];
            int dataLength = asn1bytes[i2 + 1];
            int lengthBytes = 0;
            if ((dataLength & 0x80) != 0) {
                lengthBytes = dataLength & 0x7F;
                dataLength = 0;
                for (int j2 = 0; j2 < lengthBytes; ++j2) {
                    dataLength = (dataLength << 8) + (asn1bytes[i2 + 2] & 0xFF);
                }
            }
            ++lengthBytes;
            switch (dataType) {
                case 48: 
                case 49: {
                    length = 1 + lengthBytes;
                    baos.write(asn1bytes, i2, length);
                    continue block4;
                }
                case 19: {
                    length = 1 + lengthBytes + dataLength;
                    if (length <= 4) {
                        baos.write(asn1bytes, i2, length);
                        continue block4;
                    }
                    DerValue derValue = new DerValue(asn1bytes, i2, length);
                    String stringValue = derValue.getAsString();
                    DerOutputStream dos = new DerOutputStream();
                    dos.putUTF8String(stringValue);
                    byte[] asn1Utf8Bytes = dos.toByteArray();
                    baos.write(asn1Utf8Bytes);
                    continue block4;
                }
                default: {
                    length = 1 + lengthBytes + dataLength;
                    baos.write(asn1bytes, i2, length);
                }
            }
        }
        if (asn1bytes.length != baos.size()) {
            throw new IllegalStateException("ASN1 encoding length mismatch");
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertificateChain() throws FileNotFoundException, CertificateException, IOException {
        InputStream chainStream = null;
        try {
            chainStream = this.getClass().getClassLoader().getResourceAsStream(CHAIN_RESOURCE_PATH);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(chainStream);
            for (Certificate certificate : certs) {
                if (this.signingChain.contains(certificate)) continue;
                this.signingChain.add(certificate);
            }
        }
        finally {
            if (chainStream != null) {
                chainStream.close();
            }
            chainStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSigningCert(String pkcs12SigningCertificatePath, String pkcs12SigningCertificatePassword) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        FileInputStream keyStoreFile = null;
        try {
            keyStoreFile = new FileInputStream(pkcs12SigningCertificatePath);
            keyStore.load(keyStoreFile, pkcs12SigningCertificatePassword.toCharArray());
        }
        finally {
            if (keyStoreFile != null) {
                keyStoreFile.close();
            }
            keyStoreFile = null;
        }
        Enumeration<String> aliases = keyStore.aliases();
        String alias = null;
        while (aliases.hasMoreElements()) {
            String i2 = aliases.nextElement();
            if (!keyStore.isKeyEntry(i2)) continue;
            alias = i2;
        }
        this.signingKey = (PrivateKey)keyStore.getKey(alias, pkcs12SigningCertificatePassword.toCharArray());
        this.signingCert = keyStore.getCertificate(alias);
        this.signingChain.add(this.signingCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] newDigestOfFile(File source) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        FileInputStream fis = null;
        try {
            int bytesRead;
            fis = new FileInputStream(source);
            byte[] buffer = new byte[4096];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        finally {
            fis.close();
            fis = null;
        }
        return digest.digest();
    }

    private int readIntLE(RandomAccessFile source) throws IOException {
        return source.readUnsignedByte() + (source.readUnsignedByte() << 8) + (source.readUnsignedByte() << 16) + (source.readUnsignedByte() << 24);
    }

    private void writeIntLE(RandomAccessFile target, int value) throws IOException {
        target.write(value);
        target.write(value >> 8);
        target.write(value >> 16);
        target.write(value >> 24);
    }

    public void setPrivateKey(PrivateKey key) {
        this.signingKey = key;
    }

    public void setSignerCertificate(Certificate cert) {
        this.signingCert = cert;
    }

    public void setCertificateChain(Certificate[] certchain) {
        this.signingChain = new ArrayList<Certificate>(Arrays.asList(certchain));
    }

    public void setAlsoIncludeOldStyleTimestamp() {
        throw new UnsupportedOperationException("setAlsoIncludeOldStyleTimestamp() not supported");
    }

    public void setTimestampURL(String url) {
        throw new UnsupportedOperationException("setTimestampURL() not supported");
    }

    public void setOutput(File output) {
        throw new UnsupportedOperationException("setOutput() not supported");
    }

    protected void setHashInfoPlist(byte[] hashInfoPlist) {
        this.hashInfoPlist = hashInfoPlist;
    }

    protected void setHashCodeResources(byte[] hashCodeResources) {
        this.hashCodeResources = hashCodeResources;
    }

    protected void setApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
    }

    protected void setApplicationIdentifierPrefix(String applicationIdentifierPrefix) {
        this.applicationIdentifierPrefix = applicationIdentifierPrefix;
    }
}

