/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTPackager;
import com.adobe.air.Descriptor;
import com.adobe.air.ipa.IPAOutputStream;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;

public final class IPAPackager
extends ADTPackager {
    protected static final String EMBEDDED_PROVISIONING_PROFILE = "embedded.mobileprovision";

    public IPAPackager() {
        this.setStream(new IPAOutputStream());
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("air");
    }

    protected void validateDescriptor() throws ApplicationDescriptorValidationException {
        this.m_descriptor = new Descriptor(this.m_descriptorFile);
        this.getDescriptor().validateForIPAPackaging(this.getSources());
    }

    public void setOptimizeLevel(String optLevel) {
        this.getIPAStream().setOptimizeLevel(optLevel);
    }

    public void setCompressSWF(boolean compressFlag) {
        this.getIPAStream().setCompressSWF(compressFlag);
    }

    public void setVerbose(boolean verboseFlag) {
        this.getIPAStream().setVerbose(verboseFlag);
    }

    public void setDebugger(boolean debuggerFlag) {
        this.getIPAStream().setDebugger(debuggerFlag);
    }

    public void setPackageConfiguration(String configType) {
        this.getIPAStream().setPackageConfiguration(configType);
    }

    public void setMobileProvisioningProfile(File profile) {
        this.getIPAStream().setMobileProvisioningProfile(profile);
        this.addSourceWithPath(profile, EMBEDDED_PROVISIONING_PROFILE);
    }

    public void createIPA() throws GeneralSecurityException, IOException {
        this.createPackage();
    }

    private IPAOutputStream getIPAStream() {
        return (IPAOutputStream)this.getStream();
    }
}

