/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.certificate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.server.UID;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;

class X509TBSCertificate {
    private static final byte TAG_OCT = 4;
    private static final byte TAG_OID = 6;
    private static final byte TAG_SEQ = 48;
    private static final byte TAG_CTX = -128;
    private static final byte TAG_CONS = 32;
    private static final byte TAG_PRIM = 0;
    private static final byte[] ENCODED_VERSION = new byte[]{-96, 3, 2, 1, 2};
    private static final byte[] ENCODED_SIGNATURE = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
    private static final byte[] EXTENSIONS = new byte[]{-93, 23, 48, 21, 48, 19, 6, 3, 85, 29, 37, 4, 12, 48, 10, 6, 8, 43, 6, 1, 5, 5, 7, 3, 3};
    private static final int DEFAULT_DURATION = 5;
    private static final String UTC_TIME_FORMAT = "yyMMddHHmmss'Z'";
    private final byte[] encodedSerialNumber;
    private X500Principal subject;
    private RSAPublicKey publicKey;

    public X509TBSCertificate(X500Principal subject, RSAPublicKey publicKey) {
        this.subject = subject;
        this.publicKey = publicKey;
        this.encodedSerialNumber = this.getEncodedSerialNumber();
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream s2;
        block2: {
            s2 = new ByteArrayOutputStream();
            byte[] encodedSubject = this.subject.getEncoded();
            byte[] encodedPublicKeyInfo = this.publicKey.getEncoded();
            byte[] encodedValidity = this.getEncodedValidity(5);
            try {
                s2.write(ENCODED_VERSION);
                s2.write(this.encodedSerialNumber);
                s2.write(ENCODED_SIGNATURE);
                s2.write(encodedSubject);
                s2.write(encodedValidity);
                s2.write(encodedSubject);
                s2.write(encodedPublicKeyInfo);
                s2.write(EXTENSIONS);
                byte[] encodedData = s2.toByteArray();
                s2.reset();
                s2.write(48);
                s2.write(130);
                s2.write(encodedData.length >> 8 & 0xFF);
                s2.write(encodedData.length & 0xFF);
                s2.write(encodedData);
            }
            catch (IOException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return s2.toByteArray();
    }

    public byte[] getEncodedSignature() {
        return ENCODED_SIGNATURE;
    }

    private byte[] getEncodedSerialNumber() {
        ByteArrayOutputStream s2;
        block2: {
            s2 = new ByteArrayOutputStream();
            UID uid = new UID();
            byte[] uidData = uid.toString().getBytes();
            try {
                s2.write(2);
                s2.write(uidData.length);
                s2.write(uidData);
            }
            catch (IOException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return s2.toByteArray();
    }

    private byte[] getEncodedValidity(int duration) {
        ByteArrayOutputStream s2;
        block2: {
            SimpleDateFormat sdf = new SimpleDateFormat(UTC_TIME_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            Calendar c2 = Calendar.getInstance();
            String notBefore = sdf.format(c2.getTime());
            c2.add(1, duration);
            String notAfter = sdf.format(c2.getTime());
            s2 = new ByteArrayOutputStream();
            try {
                s2.write(48);
                s2.write(30);
                s2.write(23);
                s2.write(13);
                s2.write(notBefore.getBytes());
                s2.write(23);
                s2.write(13);
                s2.write(notAfter.getBytes());
            }
            catch (IOException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return s2.toByteArray();
    }
}

