/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

public final class Message {
    private static final long serialVersionUID = 1L;
    public static final String ERROR = "ERROR";
    public final int code;
    public final String type;
    public final String file;
    public final int line;
    public final int column;
    public final String errorDescription;
    public final String[] identifiers;

    public Message(int code, String type, String file, int line, int column, String[] identifiers) {
        this.code = code;
        this.type = type;
        this.file = file;
        this.line = line;
        this.column = column;
        this.identifiers = identifiers;
        this.errorDescription = this.MakeErrorDescription();
    }

    public Message(int code, String type) {
        this(code, type, null);
    }

    public Message(int code, String type, String[] identifiers) {
        this.code = code;
        this.type = type;
        this.file = null;
        this.line = -1;
        this.column = -1;
        this.identifiers = identifiers;
        this.errorDescription = this.MakeErrorDescription();
    }

    public String MakeErrorDescription() {
        String msg = null;
        switch (this.code) {
            case 100: {
                msg = "Application descriptor cannot be parsed";
                break;
            }
            case 101: {
                msg = "Namespace is missing";
                break;
            }
            case 102: {
                msg = "Invalid namespace " + this.identifiers[0];
                break;
            }
            case 103: {
                msg = this.identifiers[0] + " is an unexpected element/attribute";
                break;
            }
            case 104: {
                msg = this.identifiers[0] + " is required";
                break;
            }
            case 105: {
                msg = this.identifiers[0] + " contains an invalid value";
                break;
            }
            case 106: {
                msg = "Illegal window attribute combination";
                break;
            }
            case 107: {
                msg = "application.initialWindow.minSize is greater than application.initialWindow.maxSize";
                break;
            }
            case 108: {
                msg = this.identifiers[0] + "=" + this.identifiers[1] + " attribute already used in prior element";
                break;
            }
            case 200: {
                msg = "Icon " + this.identifiers[0] + " cannot be opened";
                break;
            }
            case 201: {
                msg = "Icon " + this.identifiers[0] + " is wrong size";
                break;
            }
            case 202: {
                msg = "Icon " + this.identifiers[0] + " is unsupported format";
                break;
            }
            case 300: {
                msg = "File missing/cannot be opened";
                break;
            }
            case 301: {
                msg = "Application descriptor missing/cannot be opened";
                break;
            }
            case 302: {
                msg = "Root content " + this.identifiers[0] + " is missing from package";
                break;
            }
            case 303: {
                msg = "Icon " + this.identifiers[0] + " is missing from package";
                break;
            }
            case 304: {
                msg = "Initial window content is invalid";
                break;
            }
            case 305: {
                msg = "Intial window content SWF version " + this.identifiers[0] + " exceeds namespace version " + this.identifiers[1];
                break;
            }
            case 306: {
                msg = "Descriptor must support the profile " + this.identifiers[0];
                break;
            }
            case 307: {
                msg = "Descriptor must be at least namespace " + this.identifiers[0];
            }
        }
        StringBuffer msgBuffer = new StringBuffer();
        msgBuffer.append(this.file);
        if (this.line != -1) {
            msgBuffer.append("(" + this.line + ")");
        }
        msgBuffer.append(": error " + this.code);
        msgBuffer.append(": " + msg);
        return msgBuffer.toString();
    }
}

